//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
//  
using System;
using System.Text.RegularExpressions;

namespace FrameworkLibraries
{
    public class RegexMain
	{
		public static void Main(String[] args)
		{
			Regex pathregex = new Regex(@"(?<drive>[^:]:\\)?((?<dir>[^\\]+)\\)*(?<file>((?<base>[^.]+)[.]?(?<ext>.*)))");
			string s = @"c:\a\b\c\d\e.cs";

			if ( args.Length > 0 )
			{
				s = args[0];
			}

			Match mc = pathregex.Match(s);

			if ( mc.Success )
			{
				Console.WriteLine("Udao si zanalizowa \"{0}\" !!", s);
				Console.WriteLine("Dysk: " + mc.Groups["drive"].Value);
				CaptureCollection cc = mc.Groups["dir"].Captures;
				// Wywietlenie elementw w grupie.
				Console.WriteLine("Katalogi: {0}", cc.Count);
				// Ptla dla kadego elementu w grupie.
				for (int i = 0; i < cc.Count; i++) 
				{
					Console.WriteLine("{0} rozpoczyna si od znaku {1}", cc[i], cc[i].Index);
				}
				Console.WriteLine("Plik: " + mc.Groups["file"].Value);
				Console.WriteLine("Podstawa: " + mc.Groups["base"].Value);
				Console.WriteLine("Rozszerzenie: " + mc.Groups["ext"].Value);
			}
			else
			{
				Console.WriteLine(s + " nie jest poprawnym adresem cieki");
			}
		}
	}
}